jQuery(document).ready(function (){

	// Deshabilito los destinatarios ya marcados
	$(desactivarDestinos).each(function(el){
		desactivaDestinatario(desactivarDestinos[el]);
	});
	
	if(!estadoCierreRealizado && esUsuarioModificacion){
		$("#comunicacionesRERA_toolbar").rup_toolbar({
			buttons:
				[{id:"AnadirComunicacion", i18nCaption:$.rup.i18n.app.botones.AnadirComunicacion, left:true},
				 {id:"RelanzarComunicacion", i18nCaption:$.rup.i18n.app.botones.RelanzarComunicacion, left:true},
				 {id:"EnviarComunicacion", i18nCaption:$.rup.i18n.app.botones.EnviarComunicacion, left:true}]
		});
	}

	$("#comunicacionesRERA_feedback").rup_feedback({ 
		type: "ok",
		closeLink: true,
		delay: 800,
		fadeSpeed: 800,
		block:false
	});	
	
	//se inicializan los botones de relanzar y enviar comunicacion, para que si no hay comunicaciones esten deshabilitados
	$("[id='comunicacionesRERA_toolbar##RelanzarComunicacion']").button("disable");
	$("[id='comunicacionesRERA_toolbar##EnviarComunicacion']").button("disable");
	// todos los posibles destinatarios que se muestran en la ventana dialogo, se muestran seleccionados por defecto
	$("input[type='checkbox'][id^='destinatarios_']").prop( "checked", true);
	
	// se recogen todas las comunicaciones que existan para el expediente en el tramite actual
	var tComunicLista = $("input[type='hidden'][id^='tComunic_']");
	for (i=0;i<tComunicLista.length;i++){
		idcampo = tComunicLista[i].id;
		valor =  $("#"+idcampo).val();
		tipo = valor.substring(0,1);
		
		//Si no se ha hecho el cierre, se puede seguir mandando comunicaciones (estadoCierreRealizado=false)
		if(!estadoCierreRealizado && esUsuarioModificacion){
			if (habMisGestiones == 'S') {

				//Si se trata de la comunicacion a la empresa (tipo=E)
				if(tipo=="E"){
					// Si la comunicacion esta enviada y es correcta se deshabilita la opcion de volverlo a enviar (estado=1)
					if ($("#estado_"+valor).val() == '1'){
						//$("#destino_"+valor).prop("checked", true);
						$("#destino_"+valor).attr("disabled", true);
					}
					
					// Si la comunicacion esta enviada pero termina con error, se deshabilita el check de Mis gestiones, 
					//porque solo se puede mandar una vez. Ahora lo van a tener que relanzar si o si (estado=2)
					if ($("#estado_"+valor).val() == '2'){
						$("#destino_"+valor).attr("disabled", true);
					}
				}
			} else {
				//Si se trata de la comunicacion a la empresa (tipo=E)
				if(tipo=="E"){
					//No se puede mandar la comunicación a la empresa y deshabilita el destinatario de la empresa
					$("#destino_"+valor).attr("disabled", true);
					
					/*if ($("#estado_"+valor).val() == '1'){
						$("#destino_"+valor).prop("checked", true);
					}*/
				}
			}
			// Si la comunicacion esta enviada y se pone que ha ido ok (estado=1)
			if ($("#estado_"+valor).val() == '1'){
				$("#tOk_"+valor).css("display",'block');
			}
			
			// Si la comunicacion esta enviada pero termina con error, se habilita el boton de relanzar los errores (estado=2)
			if ($("#estado_"+valor).val() == '2'){
				$("[id='comunicacionesRERA_toolbar##RelanzarComunicacion']").button("enable");
				$("#tError_"+valor).css("display",'block');
			}
		}else{
			//Si se ha hecho el cierre, no se puede seguir mandando comunicaciones (estadoCierreRealizado=true)
			$("#destino_"+valor).attr("disabled", true);
			
			// Si la comunicacion esta enviada y se pone que ha ido ok (estado=1)
			if ($("#estado_"+valor).val() == '1'){
				$("#tOk_"+valor).css("display",'block');
			}
			
			// Si la comunicacion esta enviada pero termina con error, se pone que ha ido con error (estado=2)
			if ($("#estado_"+valor).val() == '2'){
				$("#tError_"+valor).css("display",'block');
			}
		}
		
		$("[id='comunicacionesRERA_toolbar##EnviarComunicacion']").button("enable");
	}
	
	$("[id='comunicacionesRERA_toolbar##AnadirComunicacion']").click(function(){
			var dialogDestinos = $("#destinatariosCom");

			dialogDestinos.rup_dialog({
				title: $.rup.i18n.app.comunicacion.seleccione,
				type: $.rup.dialog.DIV,
				autoOpen: true,
				closeOnEscape: true,
				modal: true,
				resizable: true,
				minWidth: 500,
				buttons: [{
					text: $.rup.i18n.base.rup_global.close,
					click: function() {
						dialogDestinos.rup_dialog("destroy");
					},
					btnType: $.rup.dialog.LINK
				},
				{	text: $.rup.i18n.base.rup_global.aceptar,
					click: function() {
						dialogDestinos.rup_dialog("destroy");
						nuevosDestinatarios();
					}
				}],
				open: function() {
					//$("input[type='checkbox'][id^='destinatarios_']").prop( "checked", true);
				},
				close: function() {
					//l61bUtils.feedback.cerrarFeedbacks($("#tramitacion_feedback"));
				}
			});		
	});

	$("[id='comunicacionesRERA_toolbar##EnviarComunicacion']").click(function(){
		
		lista = $("input[type='checkbox'][id^='destino_']");
		var eCorrectos = [];
		var eErroneos = [];
		for (i=0;i<lista.length;i++){
			idcampo = lista[i].id;
			valor =  $("#"+idcampo).val();
			if ($("#"+idcampo).is(':checked')){
				//listaEmails.push($("#email"+valor).val());
				//if ($("#estado_"+valor).val() == '0') {
					eCorrectos.push(valor);
				//}
			}
		}
		
		if (eCorrectos.length == 0){
    		ab03bUtils.feedback.pintarFeedbackError($.rup.i18n.app.comunicacion.seleccioneCom,  $("#tramitacion_feedback"));			
		} else {
			waitDialog();
		   $.rup_ajax({
	    	url : $.rup.CTX_PATH + "comunicacionesRERA/enviarComunicacion",
	    	dataType: 'json',
	    	data:{
	    		'destinos':eCorrectos.join("#"),
				"id028HistoTram": id028,
				"idProvincia": idProvincia,
				"idExpediente": idExpediente,
				"idAno": idAno,
				"url": $.rup.APP_STATICS
	    		},
	    	cache: false,
	    	type: "GET",
	    	contentType: 'application/json',
	    	success: function (resultado, ajaxOptions) {
	    		hayerror = 0;
	    		for (var campo in resultado){
	    			var estadoMasCierre = resultado[campo].split("_");
					var estado = estadoMasCierre[0];
					var cierre = estadoMasCierre[1];
					if(cierre == 'S'){
						estadoCierreRealizado=true;
					}else{
						estadoCierreRealizado=false;
					}
    				if (estado == '2'){
    					ab03bUtils.feedback.pintarFeedback($.rup.i18n.app.mensajes.errorEnvioComunicacion, "error", $("#tramitacion_feedback"));			
    					hayerror=1;
    				}
    			}
	    		if (hayerror==0){
	    			ab03bUtils.feedback.pintarFeedback($.rup.i18n.app.mensajes.okEnvioComunicacion, "ok",$("#tramitacion_feedback"));
	    		}
	    		//Si todo ok, se recaga la pantalla para mostrar la nueva informaci�n
	    		location.href = $.rup.CTX_PATH + "expedientesRERA/detalle/tramitacion/irTramite/" + idProvincia  + "/" +idAno  + "/" + idExpediente+"/"+id028+"/"+estadoCierreRealizado+"?tab=1";
	    	},
	   		error: function (xhr, textStatus, errorThrown) {
				//ab03bUtils.feedback.pintarFeedbackError($.rup.i18n.app.mensajes.errorEnvioComunicacion, $("#comunicaciones_feedback"));
				ab03bUtils.feedback.pintarFeedback($.rup.i18n.app.mensajes.errorEnvioComunicacion, "error", $("#tramitacion_feedback"));
			},
			complete: function() {
				$.unblockUI();
			}
	    });
		}
	});
	$("[id='comunicacionesRERA_toolbar##RelanzarComunicacion']").click(function(){
		
		var lista = $("input[type='checkbox'][id^='destino_']");
		var relanzar = [];
		for (i=0;i<lista.length;i++){
			idcampo = lista[i].id;
			valor =  $("#"+idcampo).val();
			if ($("#estado_"+valor).val() == '2') {
				relanzar.push(valor);
			}
		}
		//var relanzar = $("[id*='estado_'][value='2']").map(function(index,el){return el.id;}).toArray();
		if (relanzar.length > 0){
			waitDialog();
			$.rup_ajax({
		    	url : $.rup.CTX_PATH + "comunicacionesRERA/enviarComunicacion",
		    	dataType: 'json',
		    	data:{
		    		'destinos':relanzar.join("#"),
					"id028HistoTram": id028,
					"idProvincia": idProvincia,
					"idExpediente": idExpediente,
					"idAno": idAno
		    		},
		    	cache: false,
		    	type: "GET",
		    	contentType: 'application/json',
		    	success: function (resultado, ajaxOptions) {
		    		hayerror = 0;
		    		for (var campo in resultado){
		    			var estado = resultado[campo];
	    				if (estado == '2'){
	    					ab03bUtils.feedback.pintarFeedback($.rup.i18n.app.mensajes.errorEnvioComunicacion, "error", $("#tramitacion_feedback"));			
	    					hayerror=1;
	    				}
	    			}
		    		if (hayerror==0){
		    			ab03bUtils.feedback.pintarFeedback($.rup.i18n.app.mensajes.okEnvioComunicacion, "ok",$("#tramitacion_feedback"));
		    		}
		    		//Si todo ok, se recaga la pantalla para mostrar la nueva informaci�n
		    		location.href = $.rup.CTX_PATH + "expedientesRERA/detalle/tramitacion/irTramite/" + idProvincia  + "/" +idAno  + "/" + idExpediente+"/"+id028+"/"+estadoCierreRealizado+"?tab=1";
		    	},
		   		error: function (xhr, textStatus, errorThrown) {
					//ab03bUtils.feedback.pintarFeedbackError($.rup.i18n.app.mensajes.errorEnvioComunicacion, $("#comunicaciones_feedback"));
					ab03bUtils.feedback.pintarFeedback($.rup.i18n.app.mensajes.errorEnvioComunicacion, "error", $("#tramitacion_feedback"));
				},
				complete: function() {
					$.unblockUI();
				}
		    });
		}
	});
});
//Marca y desactiva aquellos destinatarios para los que ya se ha creado la comunicación
function desactivaDestinatario(el){
	$("#destinatarios_"+el).prop( "checked", true ).attr("disabled", true);
	$("#destinatarios_"+el).addClass("NOGENERAR");
}
function nuevosDestinatarios(){

	lista = $("input[type='checkbox'][id^='destinatarios_']");
	var arrayDestinos = [];
	for (i=0;i<lista.length;i++){
		idcampo = lista[i].id;
		valor =  $("#"+idcampo).val();
		if ($("#"+idcampo).is(':checked') && $("#"+idcampo).attr("disabled") != 'disabled'){
			arrayDestinos.push(valor);
		}
	}

	if (arrayDestinos.length > 0) {
		$.rup_ajax({
			url : $.rup.CTX_PATH + "comunicacionesRERA/addComunicaciones",
			dataType: 'json',
			data: {
				"destinos": arrayDestinos.join("#"),
				"id028HistoTram": id028
			},
	    	type: "GET",
	    	contentType: 'application/json',
			success: function (retorno){
				if (retorno = 'add'){
					//Si se dan de alta los registros en la tabla de comunicaciones se repinta la pantalla
					//location.href = $.rup.CTX_PATH + "comunicaciones/irComunicaciones/" + idProvincia + "/" + idExpediente+"/"+id028;
					location.href = $.rup.CTX_PATH + "expedientesRERA/detalle/tramitacion/irTramite/" + idProvincia + "/" +idAno  + "/" + idExpediente+"/"+id028+"/"+estadoCierreRealizado+"?tab=1";
				}
			},
			error: function(error){
				ab03bUtils.feedback.pintarFeedbackError(error.responseText, $("#comunicacionesRERA_feedback"));
			}
		});
	}
}






